<?php

class ExcelFunction {
	

function _calculate_pvif ($rate, $nper)
	{
		return (pow(1 + $rate, $nper));
	}

function _calculate_fvifa ($rate, $nper)
	{
		// Removable singularity at rate == 0
		if ($rate == 0)
			return $nper;
		else
			// FIXME: this sucks for very small rates
			return (pow(1 + $rate, $nper) - 1) / $rate;
	}
		

function _calculate_pmt ($rate, $nper, $pv, $fv, $type)
	{
		// Calculate the PVIF and FVIFA
		$pvif = $this->_calculate_pvif ($rate, $nper);
		$fvifa = $this->_calculate_fvifa ($rate, $nper);
		
		return ((-$pv * $pvif - $fv ) / ((1.0 + $rate * $type) * $fvifa));
	}
	
function _calculate_interest_part ($pv, $pmt, $rate, $per)
	{
		return -($pv * pow(1 + $rate, $per) * $rate +
			$pmt * (pow(1 + $rate, $per) - 1));
	}
	
function PPMT($rate, $per, $nper, $pv, $fv = 0.0, $type = 0)
	{
		if (($per < 1) || ($per >= ($nper + 1)))
			return null;
		else {
			$pmt = $this->_calculate_pmt ($rate, $nper, $pv, $fv, $type);
			$ipmt = $this->_calculate_interest_part ($pv, $pmt, $rate, $per - 1);
			return ((is_finite($pmt) && is_finite($ipmt)) ? $pmt - $ipmt: null);
		}
	}
	
function IPMT($rate, $per, $nper, $pv, $fv = 0.0, $type = 0)
{
	if (($per < 1) || ($per >= ($nper + 1)))
		return null;
	else {
		$pmt = $this->_calculate_pmt ($rate, $nper, $pv, $fv, $type);
		$ipmt = $this->_calculate_interest_part ($pv, $pmt, $rate, $per - 1);
		return (is_finite($ipmt) ? $ipmt: null);
	}
}
	
}

$ExcelFunction = new ExcelFunction();	
?>	