<?php

class nafa_dealer_statement
{
	
	function getDealerStatementDownload($dealer_code,$from_date,$to_date,$download_type,$email=false,$link) {	
	
		
		$obj = new active_record();
		$cam = new cam();				
			
		$from_date=strtotime($from_date); 
		$from_date=($from_date ? date("Y-m-d", $from_date) : '');
		
		$to_date=strtotime($to_date);
		$to_date=($to_date ? date("Y-m-d", $to_date) : '');


		$condition="";
		if($dealer_code!="")
		{
			$condition.="A.fk_dealer_id='$dealer_code' AND ";	
		}
		if($product_name!="")
		{
			$condition.="A.dealer_product='$product_name' AND ";	
		}
		if($from_date!="" && $to_date!="")
		{
			$condition.="A.dealer_date between '$from_date' AND '$to_date' AND ";	
		}

		$condition=rtrim($condition," AND ");


		$dealer=$obj->select("dealer_name,dealer_office_name,dealer_address,nafa_dealer_code","dealer_info_master b","dealer_code='$dealer_code'",$link);	

		$ans=$obj->select_join("A.*","dealer_statement A","LEFT JOIN (SELECT * FROM dealer_statement WHERE fk_dealer_id= (SELECT MIN(fk_dealer_id) FROM dealer_statement WHERE dealer_date=(SELECT MAX(dealer_date) FROM dealer_statement ORDER BY fk_dealer_id))) B USING (statement_id)","$condition ORDER BY IFNULL(B.statement_id,-1),fk_dealer_id,dealer_date",$link);


		$last_date=$obj->select("dealer_date","dealer_statement A","$condition ORDER BY dealer_date desc limit 1",$link);
		
		
		$block_dealer=array('218272','174395');
		if(in_array($dealer_code,$block_dealer)){

			echo "<p style='text-align:center;'>no record found!</p>";
			die;
		}
		
		if($download_type=='1') {
			
			if($email=='1'){
				$stmt_neader='Statement Details for the month of <strong style="font-size: 14px;">'.date("M'y",strtotime($last_date[0]["dealer_date"])).'</strong>';
			}
			else{
				$stmt_neader='Statement Details as on <strong style="font-size: 14px;">'.$obj->oracle_date($last_date[0]["dealer_date"]).'</strong>';
			}
		
		$html='';
		$html.='<html>
		<head>
		<style>
		body {font-family: sans-serif;font-size: 10pt;}
		p {	margin: 0pt; }
		table.items {border: 0.1mm solid #000000;}
		td { vertical-align: top; }
		.items td {	border-left: 0.1mm solid #000000;border-right: 0.1mm solid #000000;}
		table thead td { background-color: #EEEEEE;	text-align: center;	border: 0.1mm solid #000000;font-variant: small-caps;}
		.items td.blanktotal { background-color: #EEEEEE;border: 0.1mm solid #000000;background-color: #FFFFFF;border: 0mm none #000000;border-top: 0.1mm solid #000000;border-right: 0.1mm solid #000000;}
		.items td.totals { text-align: right;border: 0.1mm solid #000000;}
		.items td.cost { text-align: "." center;}
		.ss_page_title { margin-top:-0px; background: #c6c8c8;border-color: #202426 color: #fff; width: 100%; height:2%;margin-bottom:-1px;}
		table.ss_table {border-collapse: collapse;}
		.ss_table td, .ss_table th {border: 1px solid black;padding: 3px;}
		</style>
		</head>
		<body>

		';


		$html.='<div >
		<div style="width: 45%;float: left;">
		<table style="margin-top: 0px;border:1px solid;">
			<tr><th width="110" align="left">Name</th><td>'.$dealer[0]["dealer_name"].'</td></tr>
			<tr><th align="left">Agency Name</th><td>'.$dealer[0]["dealer_office_name"].'</td></tr>
			<tr><th align="left" height="50">Location</th><td>'.$dealer[0]["dealer_address"].'</td></tr>
			<tr><th align="left">Customer Code</th><td>'.$dealer[0]["nafa_dealer_code"].'</td></tr>
		</table>
		</div>';


		$html.='
		<div style="float: left;  width: 53%;border:1px solid;margin-left:12px;">
		'.$obj->GetDealerStatementSummary($dealer_code,$link).'
		</div>			
		</div>		
		<br/>';


		$html.='<table border="1" class="items" width="100%" style="font-size: 7pt; border-collapse: collapse; " cellpadding="8">
		<tr>
		<th colspan="9" align="left" height="25" style="font-size: 12px;">'.$stmt_neader.'</th>
		</tr>
		<thead>
		<tr >				
		<td>Date</td>
		<td>Loan/Ref No.</td>
		<td>NIIPL Order No.</td>
		<td>Product</td>
		<td>Description</td>
		<td>Txn Type</td>
		<td>Receipt No.</td>	
		<td>Debit (Rs.)</td>
		<td>Credit (Rs.)</td>
		<td>Balance (Rs.)</td>				
		</tr>
		</thead>
		';



		if($ans){
		for($i=0;$i<count($ans);$i++)
		{	
		$dd=date("d-M-Y",strtotime($ans[$i]["dealer_date"]));	


		$html.='<tr>

		<td align="center">'.$dd.'</td>
		<td align="center">'.$ans[$i]["reference_no"].'</td>
		<td align="center">'.$obj->getDFOrderNumber($ans[$i]["reference_no"],$link).'</td>
		<td align="center">'.$ans[$i]["dealer_product"].'</td>
		<td>'.$ans[$i]["dealer_description"].'</td>
		<td align="center">'.$ans[$i]["tran_type"].'</td>
		<td>'.$ans[$i]["receipt_no"].'</td>
		<td align="right">'.$cam->make_roundoff($ans[$i]["debit"]).'</td>
		<td align="right">'.$cam->make_roundoff($ans[$i]["credit"]).'</td>
		<td align="right">'.$cam->make_roundoff($ans[$i]["balance"]).'</td>
		</tr>';

		} } else{

		$html.='<tr>
		<td colspan="9" align="center">No Data Found!</td>
		</tr>';
		}
		$html.='</table>';
		
		$html.=$this->getDealerStatementCollateral($dealer_code,$from_date,$to_date,'download',$link);
		
		$html.=' 
		<table style="width:90%;font-size:10px;">
		<tr><th align="left" class="ss_tr_th">Legends Used in Account Statement</th></tr>
		<tr><td>DF-R -> DEALER FINANCING - REGULAR</td></tr>
		<tr><td>SAHAJ -> DEALER FINANCING - SAHAJ</td></tr>
		<tr><td>PRAGATI -> DEALER FINANCING - PRAGATI</td></tr>
		<tr><td>BL -> DEALER FINANCING - BANK LETTER</td></tr>
		<tr><td>FCE -> FARMER FINANCING UNDER SUGAR MILL</td></tr>
		<tr><td>VIIDP -> VIDARBHA INTENSIVE IRRRGATION DEVELOPMENT PROGRAMME</td></tr>
		<tr><td>DIS -> DISBURSEMENT</td></tr>
		<tr><td>CM -> CREDIT MEMO</td></tr>  
		<tr><td>NIIPL -> NETAFIM IRRIGATION INDIA PVT. LTD.</td></tr>
		<tr><td>PF -> PROCESSING FEE</td></tr>
		<tr><td>Ins -> INSURANCE</td></tr>
		<tr><td>ST -> SERVICE TAX</td></tr>
		<tr><td>REC -> Funds Received</td></tr>
		<tr><td>Receipt No. - NIIPL_(Name of the Dealer) -> Denotes that the fund/payment received from NIIPL or fund/receipt adjusted against the credit balance in NIIPL dealer a/c  </td></tr> 
		
		<tr><th align="left" class="ss_tr_th">Note:</th></tr>
		<tr><td>Pls note Products SAHAJ & PRAGATI have been clubbed into Flexi Business Loan (FBL) w.e.f 18th Jan’16 for better convenience</td></tr>
		
		  
		</table>
';

		$html.='</body>
		</html>
		';
		//echo $html;
		//die;
		include("mpdf60/mpdf.php");
		
		$FolderPath='dealer_statement/pdf/';
		
		$PdfName=$this->nafa_replace_space($dealer[0]["dealer_office_name"]).'_statement.pdf';			
		$PdfName=$FolderPath.$PdfName;
		$mpdf=new mPDF('c','A4','','',7,8,27,5,5,5); 
		//$mpdf = new mPDF('c','A4', 0, '', 15, 15, 16, 16, 9, 9, 'L');
		$mpdf->SetProtection(array('print'));
		$mpdf->SetHTMLHeader('<div style="text-align: right;"><img src="img/nafa_logo_pdf.jpg" /></div>', 'O');
		//$mpdf->SetWatermarkText("NAFA");
		//$mpdf->showWatermarkText = true;
		//$mpdf->watermark_font = 'DejaVuSansCondensed';
		//$mpdf->watermarkTextAlpha = 0.1;
		//$mpdf->SetDisplayMode('fullpage');
		$html = mb_convert_encoding($html, 'UTF-8', 'UTF-8');
		$mpdf->WriteHTML($html);
		
		if($email=='1')
			return $mpdf->Output($PdfName,'F'); 
		else		
			return $mpdf->Output($PdfName,'D'); 
		
		exit;
		
		}
		
		
		if($download_type=='2') {
			
			$output= "";
			$output.= "Statement Details as on ".$obj->oracle_date($last_date[0]["dealer_date"])."";
			$output .="\n";
			$output .='"Date","Loan/Ref No.","NIIPL Order No.","Product","Description","Txn Type","Receipt No.","Debit (Rs.)","Credit (Rs.)","Balance (Rs.)"';
			$output .="\n";
			
			if($ans){
			for($i=0;$i<count($ans);$i++)
			{	
			$dd=date("d-M-Y",strtotime($ans[$i]["dealer_date"]));	

			$output .= '"'.$dd.'","'.$ans[$i]["reference_no"].'","'.$obj->getDFOrderNumber($ans[$i]["reference_no"],$link).'","'.$ans[$i]["dealer_product"].'","'.$ans[$i]["dealer_description"].'","'.$ans[$i]["tran_type"].'","'.$ans[$i]["receipt_no"].'","'.$cam->make_roundoff($ans[$i]["debit"]).'","'.$cam->make_roundoff($ans[$i]["credit"]).'","'.$cam->make_roundoff($ans[$i]["balance"]).'",';
			
			$output .="\n";
			
			
			}
			}

			
			
			// Download the file
			
			$axy = "DS-".str_replace(" ","-",$dealer[0]["dealer_office_name"]).'-'.$from_date.'-To-'.$to_date;

			$filename =  $axy.".csv";
			header('Content-type: application/csv');
			//header('Content-Disposition: attachment; filename='.$filename);
			header("Content-Disposition: attachment; filename=\"".$filename."\"");

			echo $output;
			exit;
			
		}	
		
		
	}
	
	
	function getDealerStatementCollateral($dealer_code,$from_date,$to_date,$type,$link){
		
		$obj = new active_record();
		$cam = new cam();
		
		$coll_ans=$obj->select_join("short_term_line,niipl_order_no,dealer_commission_to_be_held","df_dam a"," RIGHT JOIN nafa_df_collateral b  ON a.short_term_line=b.fk_stl_no","b.fk_dealer_code='$dealer_code' AND status not in('Paid Off','Canceled','Request Info') AND dam_approved_date!='0000-00-00'",$link);
		
		if($type=='download'){
			$t='border="1" class="items" width="60%" style="font-size: 7pt; border-collapse: collapse; " cellpadding="8"';
			$tr='style="background-color: #EEEEEE;"';
		}
		else{
			$t='style="width: 40%" class="sortable"';
			$tr='style="height: 27px;line-height: 27px;background-color: #81AED9;  cursor: pointer;"';
		}
		$collateral_html.='<table '.$t.' >
			<tr>
				<th colspan="3">Collateral Held</th>
			</tr>
			<tr '.$tr.'>

				<th>Sales Order No</th>
				<th>STL No.</th>
				<th>Amount</th>
		</tr>';
	
	
		if($coll_ans){
			for($c = 0; $c < count($coll_ans); $c++){
	
	
			$collateral_html.='<tr>
				<td>'.$coll_ans[$c]["niipl_order_no"].'</td>
				<td>'.$coll_ans[$c]["short_term_line"].'</td>
				<td>'.$cam->make_roundoff($coll_ans[$c]["dealer_commission_to_be_held"]).'</td>
			</tr>';
			
				}
			}
			else{
				$collateral_html.='<tr><td colspan="10" align="center">No Data Found!</td></tr>';
			}
	
$collateral_html.='</table>';

		
		return $collateral_html;
		
	}
	
	function DSMasterRecalculate($getDealerCode,$link) {
		
		$obj = new active_record();
		$cam = new cam();
		
		$de=$obj->select("dealer_code","dealer_info_master","dealer_code='$getDealerCode' GROUP BY dealer_code",$link);
	
		for($j=0;$j<count($de);$j++) {	
	
			$dealer_code=$de[$j]["dealer_code"];
			$ans=$obj->select_join("A.*","dealer_statement A","LEFT JOIN (SELECT * FROM dealer_statement WHERE fk_dealer_id= (SELECT MIN(fk_dealer_id) FROM dealer_statement WHERE dealer_date=(SELECT MAX(dealer_date) FROM dealer_statement ORDER BY fk_dealer_id))) B USING (statement_id)","A.fk_dealer_id='$dealer_code'  ORDER BY IFNULL(B.statement_id,-1),fk_dealer_id,dealer_date",$link);		
	
			$currentmonthopening='0';
	
			for($i = 0; $i < count($ans); $i++){
		
				$tmp_ds_id=$ans[$i]["statement_id"];
				$tmp_debit=$ans[$i]["debit"];
				$tmp_credit=$ans[$i]["credit"];
				$balance= $cam->make_roundoff_two($currentmonthopening+$tmp_debit-$tmp_credit);	
				
				$updatebalance=$obj->exe($link,"UPDATE dealer_statement SET balance='$balance' WHERE statement_id='$tmp_ds_id'");
				
				$currentmonthopening=$balance;
			}
				
				$currentmonthopening='0';
		}
	
		if($updatebalance){
			
			return true;
			//$obj->set_flash("msgdone","Recalculation done successfully!","check_dealer_statement.php?customer_code=$customer_code");
		}
		
		
	}
	
	function DSOutstandingSMS($getDealerCode,$link){
		
		$obj = new active_record();
		$dm=$obj->select("mobile_no","dealer_info_master","dealer_code='$getDealerCode'",$link);
		$df_summary=$obj->select("ROUND(SUM(pri_out)) as total_pri_out ,ROUND(SUM(int_out)) as total_int_out ,ROUND(SUM(pf_out)) as total_pf_out,summary_date","dealer_statement_summary","fk_dealer_code='$getDealerCode'",$link);
		
		$to=$dm[0]["mobile_no"];
		$total_pri_out=$df_summary[0]["total_pri_out"];
		$total_int_out=$df_summary[0]["total_int_out"];
		$total_pf_out=$df_summary[0]["total_pf_out"];
		$summary_date=$df_summary[0]["summary_date"];
		$todays_date=date("Y-m-d");
		$due_date=date("d M'y",strtotime($summary_date));
		//$pay_date=date("d M'y",strtotime($summary_date.' + 10 days'));
		$pay_date=date("d M'y",strtotime($todays_date.' + 10 days'));
		
		$message="Dear Customer, Interest due $due_date on your loan a/c is Rs $total_int_out.Pl pay by $pay_date. Total principal o/s on your a/c is Rs $total_pri_out.Pl ignore if paid,T&C*";
		
		$data='<?xml version="1.0" encoding="UTF-8"?><xmlapi><auth><apikey>9806222a6q7pk104wdhu</apikey></auth><sendSMS><to>'.$to.'</to><text>'.$message.'</text><msgid>1</msgid><sender>NAFAPL</sender><dlrurl>http://test.dlrurl.com</dlrurl></sendSMS></xmlapi>';

		$url = "http://connect.smsmantra.in/api/xmlapi.php?data="
		.urlencode($data);
    
    	$response = file_get_contents($url);
		
		$message1="Dear Sir, A/c stmt. with principal o/s & Int due can be downloaded from http://mobility.netafimindia.com/NAFA Contact local NAFA representative incase of query";
		$to='9175075520';
		$data1='<?xml version="1.0" encoding="UTF-8"?><xmlapi><auth><apikey>9806222a6q7pk104wdhu</apikey></auth><sendSMS><to>'.$to.'</to><text>'.$message1.'</text><msgid>1</msgid><sender>NAFAPL</sender><dlrurl>http://test.dlrurl.com</dlrurl></sendSMS></xmlapi>';

		$url1 = "http://connect.smsmantra.in/api/xmlapi.php?data="
		.urlencode($data1);
    
    	$response1 = file_get_contents($url1);
    	
    	
	}
	
	function DSEmail($getDealerCode,$link,$month,$year){		
		$obj = new active_record();
		$nafa_report = new nafa_report();
		$ds=$obj->select("dealer_date","dealer_statement","fk_dealer_id='$getDealerCode' ORDER BY dealer_date DESC LIMIT 1",$link);
		$dealer_date=$ds[0]["dealer_date"];
		
		$df_summary=$obj->select("ROUND(SUM(pri_out)) as total_pri_out ,ROUND(SUM(int_out)) as total_int_out ,ROUND(SUM(pf_out)) as total_pf_out,summary_date","dealer_statement_summary","fk_dealer_code='$getDealerCode' AND summary_date>= '".$year."-".$month."-01' AND summary_date<= '".$year."-".$month."-31'",$link);
		
		$to=$dm[0]["mobile_no"];
		$total_pri_out=number_format($df_summary[0]["total_pri_out"],2);
		$total_int_out=number_format($df_summary[0]["total_int_out"],2);
		$total_pf_out=$df_summary[0]["total_pf_out"];
		$summary_date=$df_summary[0]["summary_date"];
		$todays_date=date("Y-m-d");
		$due_date=date("d M'y",strtotime($summary_date));
		$due_date_mon=date("M'",strtotime($summary_date));
		$due_date_yr=date("y",strtotime($summary_date));

		//$pay_date=date("d M'y",strtotime($summary_date.' + 10 days'));
		$pay_date=date("d M'y",strtotime($todays_date.' + 10 days'));
		
		//$from_date=date('Y-m-01',strtotime('first day of last month'));
		//$to_date=date('Y-m-t',strtotime('last day of last month'));
		$from_date=date('Y-m-01',strtotime($dealer_date));
		$to_date=date('Y-m-t',strtotime($dealer_date));
		//echo $getDealerCode;
		//$ans=$this->getDealerStatementDownload($getDealerCode,$from_date,$to_date,1,1,$link);		
		$dinfo=$obj->select("dealer_office_name,email_id","dealer_info_master","dealer_code='$getDealerCode'",$link);
		$PdfName=$this->nafa_replace_space($dinfo[0]["dealer_office_name"]).'_statement.pdf';
		$ajattachment="dealer_statement/pdf/".$PdfName;
		//$ajattachment2="dealer_statement/pdf/Abhinav-Agro-Services_statement.pdf";
		$dealer_email_id=trim($dinfo[0]["email_id"]);
	
		//if($dealer_email_id!=''){
			
		$ajfrom="no-reply@nafa.co.in";		
		//$ajto=$dealer_email_id;
		$ajsubject="NAFA Dealer Statement - $due_date_mon $due_date_yr";
		//$ajbody="test";
		$ajbody="<b>Dear Customer,</b><br><br>
Warm greetings from NAFA!.<br><br>
Please find attached your monthly statement for the month of <b>$due_date_mon $due_date_yr</b>. The total Principal and Interest outstanding amounts as on <b>$due_date</b> are INR <b>$total_pri_out</b> and <b>$total_int_out</b> respectively, payable by <b>$pay_date</b>.<br><br>
Your NAFA e-statement is now being sent to you as a pdf document.
To open this file, you need Adobe Acrobat Reader.Statement can also be downloaded from http://mobility.netafimindia.com/NAFA/<br><br>
We thank you for using our services and take pride in having you as our customer. Assuring you of our best services at all times.
<br><br>
<b>Best Regards,</b><br>
Team NAFA<br><br><br>
You can reach us at  <b>022-61707626 / 022-61707628</b> or email us at accounts_ho@nafa.co.in incase of any query.
<br><br>
The information contained in this email may be confidential and/or legally privileged. It has been sent for the sole use of the intended recipient(s). If the reader of this message is not an intended recipient, you are hereby notified that any unauthorized review, use, disclosure, dissemination, distribution, or copying of this communication, or any of its contents, is strictly prohibited. If you have received this communication in error, please reply to the sender and destroy all copies of the message.";		
		//$ajto="pooja.sharma@nafa.co.in,prachee.purandare@nafa.co.in";
        $dealer_email_id = 'pandurang.aglave@nafa.co.in,prachee.purandare@nafa.co.in';
		//$ajto=$dealer_email_id.",accounts_ho@nafa.co.in";
		$ajto=$dealer_email_id;
		return $nafa_report->send_ajmail($ajfrom,$ajto,$ajsubject,$ajbody,0,$ajattachment,$ajatype=0);		
		//$nafa_report->send_ajmail("sachin.kuchehar@nafa.co.in","ajit.singh@nafa.co.in","ds stmt","test",0,$ajattachment2,$ajatype=0);		
		//}
	}	
	function nafa_replace_space($name){
		
		$pdf_name= preg_replace("~[\W\s]~"," ",strtoupper($name));
		return $pdf_name= preg_replace("!\s+!","-",$pdf_name);
	}
	
}

$obj_nds = new nafa_dealer_statement();

?>