<?php
class dfcam extends active_record
{
	
	function sahaj_pargati(){
		
		return $sahaj_pargati=array('SAHAJ','PRAGATI','SAHAJ CMT','BL','FBL','REGULAR');
	}

	function get_dealer_info($field,$dealer_code,$link){
		$ans= $this->select("$field","dealer_info_master","dealer_code='$dealer_code'",$link);
		return $ans[0][$field];
	}
	
	function get_date_diff($from_date,$to_date,$format){
		
		
		$today_date = new DateTime($from_date);
		$dob = new DateTime($to_date);
		$interval = $dob->diff($today_date);
		return $interval->format($format);
		
		/*
		$today_date=strtotime(date('Y-m-d'));
		$dob=strtotime($this->get_dealer_info('dealer_dob',$dealer_code));
		$diff=$today_date-$dob;
		echo $diff/ (60*60*24*365);
		*/
	}
	
	function get_days_diff($start_date,$end_date){
		
			$start_date = strtotime($start_date);
			$end_date = strtotime($end_date);

			return $days_between = ceil(abs($end_date - $start_date) / 86400);
	}
	
	

	function get_age_score($age,$product,$sub_product)
	{
		
		if($product=='REGULAR_old') {
		
			if($age>40 && $age <=50) { $age_score='8';	}
			elseif($age>30 && $age <=40) { $age_score='6';	}
			elseif($age>50 && $age <=60) { $age_score='4';	}
			elseif($age>0 && $age <=30)	{ $age_score='2';	}
			elseif($age>60)	{ $age_score='1'; }
		
		}
		if(in_array($product,$this->sahaj_pargati())) {
		
			if($age>40 && $age <=50) { $age_score='10';	}
			elseif($age>30 && $age <=40) { $age_score='8';	}
			elseif($age>50 && $age <=60) { $age_score='4';	}
			elseif($age>0 && $age <=30)	{ $age_score='2';	}
			elseif($age>60)	{ $age_score='2'; }
		
		}
		return $age_score;
		
	}
	
	function get_number_operation_score($year,$product,$sub_product)
	{
		if($product=='REGULAR_old') {
		
			if($year>4) { $year_score='8';}
			elseif($year>3 && $year <=4) { $year_score='6';	}
			elseif($year>2 && $year <=3) { $year_score='4';	}
			elseif($year>=1 && $year <=2) { $year_score='2';	}
			elseif($year<1)	{ $year_score='0'; }
		
		}
		if(in_array($product,$this->sahaj_pargati())) {
		//year=month
			
			if($year>0 && $year <=12) { $year_score='2';	}
			elseif($year>13 && $year <=36) { $year_score='6';	}
			elseif($year>=37 && $year <=60)	{ $year_score='8';	}
			elseif($year>60)	{ $year_score='10'; }
		
		}
		return $year_score;
		
	}
		
	function get_niipl_relation_score($year,$product,$sub_product)
	{
		if($product=='REGULAR_old') {
		
		if($year>4) { $year_score='8';}
		elseif($year>3 && $year <=4) { $year_score='6';	}
		elseif($year>2 && $year <=3) { $year_score='4';	}
		elseif($year>=1 && $year <=2) { $year_score='2';	}
		elseif($year<1)	{ $year_score='0'; }
		
		}
		if(in_array($product,$this->sahaj_pargati())) {
		//year=month
			if($year>0 && $year <=12) { $year_score='2';	}
			elseif($year>13 && $year <=24) { $year_score='6';	}
			elseif($year>=25 && $year <=36)	{ $year_score='8';	}
			elseif($year>36) { $year_score='10'; }
		
		}
		return $year_score;
		
	}
	
	function get_track_order_niipl($value,$product,$sub_product){
		
		if(in_array($product,$this->sahaj_pargati())) {
		
			if($value==0 || in_array($value,array('nil','NIL','Nil'))) { $track_order='10';	}
			elseif($value>1 && $value <=3) { $track_order='8';	}
			elseif($value>=3 && $value <=5)	{ $track_order='4';	}
			elseif($value>5)	{ $track_order='2'; }
		
		}
		return $track_order;		
		
	}
	
	function get_niipl_overdue_loan($value,$product,$sub_product){
		
		if(in_array($product,$this->sahaj_pargati())) {
		
			if($value<10) { $niipl_overdue='10';	}
			elseif($value>11 && $value <=50) { $niipl_overdue='8';}
			elseif($value>=51 && $value <=99) { $niipl_overdue='4';	}
			elseif($value>100)	{ $niipl_overdue='2'; }
		
		}
		return $niipl_overdue;		
		
	}
	
	function get_per_cash_carry($value,$product,$sub_product){
		
		if(in_array($product,$this->sahaj_pargati())) {
		
			if($value<40) { $niipl_overdue='2';	}
			elseif($value>40 && $value <=59) { $niipl_overdue='4';}
			elseif($value>=60 && $value <=79) { $niipl_overdue='8';	}
			elseif($value>=80 && $value <=100) { $niipl_overdue='10'; }
		
		}
		return $niipl_overdue;		
		
	}
	
	function get_overdue_repayment($value,$product,$sub_product){
		
		if(in_array($product,$this->sahaj_pargati())) {
		
			if($value=='NIL Outstanding / Not Availed') { $niipl_overdue='10';	}
			elseif($value=='There is are payables to other institutions but not under Overdue') { $niipl_overdue='10';}
			elseif($value=='There are overdues/ payables to other financial institutions') { $niipl_overdue='5';	}
		
		}
		return $niipl_overdue;
		
	}
	
	function get_cibil_score($value,$product,$sub_product){
		
		if(in_array($product,$this->sahaj_pargati())){
			
			if($value>750){$cibil_score='10';}
			elseif($value>650 && $value<=750) { $cibil_score='8'; }
			elseif($value>350 && $value<=649 || $value=='NA' || $value=='-1') { $cibil_score='6'; }
		}
			elseif($value<350) { $cibil_score='2'; }
			
			return $cibil_score;
	}
	
	
	function get_instance_number($value,$product,$sub_product){
		
		if(in_array($product,$this->sahaj_pargati())) {
		
			if($value==0 || in_array($value,array('nil','NIL','Nil'))) { $track_order='10';	}
			elseif($value>1 && $value <=3) { $track_order='8';	}
			elseif($value>=3 && $value <=5)	{ $track_order='4';	}
			elseif($value>5)	{ $track_order='2'; }		
		}
		return $track_order;	
	}
	
	function get_instance_number_30_60($value,$product,$sub_product){
		
		if(in_array($product,$this->sahaj_pargati())) {
		
			if($value==0 || in_array($value,array('nil','NIL','Nil'))) { $track_order='10';	}
			elseif($value>1 && $value <=3) { $track_order='8';	}
			elseif($value>=3 && $value <=5)	{ $track_order='4';	}
			elseif($value>5) { $track_order='2'; }		
		}
		return $track_order;	
	}
	function get_instance_number_60_90($value,$product,$sub_product){
		
		if(in_array($product,$this->sahaj_pargati())) {
		
			if($value==0 || in_array($value,array('nil','NIL','Nil'))) { $track_order='10';	}
			elseif($value>1 && $value <=3) { $track_order='8';	}
			elseif($value>=3 && $value <=5)	{ $track_order='4';	}
			elseif($value>5)	{ $track_order='2'; }		
		}
		return $track_order;	
	}
	function get_instance_number_90_120($value,$product,$sub_product){
		
		if(in_array($product,$this->sahaj_pargati())) {
		
			if($value==0 || in_array($value,array('nil','NIL','Nil'))) { $track_order='10';	}
			elseif($value>1 && $value <=3) { $track_order='8';	}
			elseif($value>=3 && $value <=5)	{ $track_order='4';	}
			elseif($value>5)	{ $track_order='2'; }		
		}
		return $track_order;	
	}
	function get_instance_number_120_180($value,$product,$sub_product){
		
		if(in_array($product,$this->sahaj_pargati())) {
		
			if($value==0 || in_array($value,array('nil','NIL','Nil'))) { $track_order='10';	}
			elseif($value>1 && $value <=3) { $track_order='8';	}
			elseif($value>=3 && $value <=5)	{ $track_order='4';	}
			elseif($value>5)	{ $track_order='2'; }		
		}
		return $track_order;	
	}
	
	function get_principal_bucket_nafa($value,$product,$sub_product){
		
		if(in_array($product,$this->sahaj_pargati())) {
		//year=month
			if($year < 12) { $year_score='10';	}
			elseif($year>9 && $year <=12){ $year_score='-5';}
			elseif($year>6 && $year <=9) { $year_score='0'; }
			elseif($year>3 && $year <=6) { $year_score='5'; }
			elseif($year>0 && $year <=3) { $year_score='10';}
		}
		return $year_score;	
	}
	
	function get_repayment_value($value,$product,$sub_product){
		
		if(in_array($product,$this->sahaj_pargati())) {
		
			if($value>0 && $value<=9) { $niipl_overdue='2';	}
			elseif($value>10 && $value <=49) { $niipl_overdue='6';}
			elseif($value>=50 && $value <=79) {$niipl_overdue='8';	}
			elseif($value>80) { $niipl_overdue='10'; }
	
		}
		return $niipl_overdue;	
	}
	
	function get_excess_collateral($value,$product,$sub_product){
		
		if(in_array($product,$this->sahaj_pargati())) {
		
			if($value>0 && $value<=30) { $niipl_overdue='4';	}
			elseif($value>30 && $value <=39) { $niipl_overdue='6';}
			elseif($value>=40 && $value <=49) {$niipl_overdue='8';	}
			elseif($value>50) { $niipl_overdue='10'; }
	
		}
		return $niipl_overdue;
	}
	
	function get_expected_to_score($to_per,$product,$sub_product)
	{
		//echo $to_per;
		if($product=='REGULAR_old') {
		
		if($to_per>40) { $expected_to_score='10';}
		elseif($to_per>30 && $to_per <=40) { $expected_to_score='8';	}
		elseif($to_per>20 && $to_per <=30) { $expected_to_score='6';	}
		elseif($to_per>1 && $to_per <=20) { $expected_to_score='4'; }
		else { $expected_to_score='0'; }
		
		}
		return $expected_to_score;
		
	}
	
	function get_income_other_score($to_per,$product,$sub_product)
	{
		if($product=='REGULAR_old') {
		
		if($to_per>50) { $expected_to_score='10';}
		elseif($to_per>25 && $to_per <=50) { $expected_to_score='8';	}
		elseif($to_per>10 && $to_per <=25) { $expected_to_score='6';	}
		elseif($to_per>0 && $to_per <=10) { $expected_to_score='4'; }
		
		}
		return $expected_to_score;
		
	}
		
	function get_fix_obligation_score($to_per,$product,$sub_product)
	{
		if($product=='REGULAR_old') {
		
		if($to_per>50 || $to_per <=60) { $expected_to_score='10';}
		elseif($to_per>60 || $to_per <=70) { $expected_to_score='8';	}
		elseif($to_per>70 || $to_per <=80) { $expected_to_score='6';	}
		elseif($to_per>80) { $expected_to_score='4'; }
		
		}
		return $expected_to_score;
		
	}
	
	function get_net_worth_score($value,$product,$sub_product)
	{
		if($product=='REGULAR_old') {
		
		if($value>5) { $expected_to_score='10';}
		elseif($value>4 && $value <=5) { $expected_to_score='8';	}
		elseif($value>3 && $value <=4) { $expected_to_score='6';	}
		elseif($value>1 && $value <=3) { $expected_to_score='4';	}
		elseif($value<1) { $expected_to_score='2'; }
		
		}
		return $expected_to_score;
		
	}
	
	function get_increase_dscr_score($value,$product,$sub_product)
	{
		if($product=='REGULAR_old') {
		
		if($value>30) { $expected_to_score='10';}
		elseif($value>20 && $value <=30) { $expected_to_score='8';	}
		elseif($value>10 && $value <=20) { $expected_to_score='6';	}
		elseif($value>=0 && $value <=10) { $expected_to_score='4';	}
		
		
		}
		return $expected_to_score;
		
	}
	
	function get_source_income_score($value,$product,$sub_product)
	{
		if($product=='REGULAR_old') {
		
		if($value=='NIIPL Dealer +Allied products') { $expected_to_score='8';}
		elseif($value=='NIIPL Dealer') { $expected_to_score='4';	}		
		
		}
		return $expected_to_score;
		
	}
	
	function get_avg_obligation_score($value,$product,$sub_product)
	{
		if($product=='REGULAR_old') {
		
		if($value>40) { $expected_to_score='10';}
		elseif($value>30 && $value <=40) { $expected_to_score='8';	}
		elseif($value>20 && $value <=30) { $expected_to_score='6';	}
		elseif($value>0 && $value <=20) { $expected_to_score='4';	}
		
		
		}
		return $expected_to_score;
		
	}
	
	function get_over_due_score($value,$product,$sub_product)
	{
		if($product=='REGULAR_old') {
		
		if($value=='NIL Outstanding / There is are payables to other institutions but not under Overdue') { $expected_to_score='10';}
		elseif($value=='Not Availed') { $expected_to_score='5';	}		
		elseif($value=='There are overdues/ payables to other financial institutions') { $expected_to_score='5';	}		
		
		}
		return $expected_to_score;
		
	}
	
	function get_overdue_niipl_score($value,$product,$sub_product)
	{
		if($product=='REGULAR_old') {
		
		if($value=='Nil Outstanding with NIIPL/ is not over due') { $expected_to_score='10';}
		elseif($value>0 || $value<=30) { $expected_to_score='8';	}		
		elseif($value>30 || $value<=90) { $expected_to_score='6';	}
		elseif($value>90 || $value<=180) { $expected_to_score='4';	}		
		elseif($value>180) { $expected_to_score='0';	}				
		
		}
		return $expected_to_score;
		
	}
	
	function get_highest_coll_score($value,$product,$sub_product)
	{
		if($product=='REGULAR_old') {
		
		if(in_array($value,array('Self occupied Residential','Commercial'))) { $expected_to_score='8';}
		elseif(in_array($value,array('Rented Residential','Commercial'))) { $expected_to_score='6';	}		
		elseif(in_array($value,array('Agriculture land','Non- Agricultural land','plot (Residential/Commercial)'))) { $expected_to_score='4';	}		
		
		}
		return $expected_to_score;
		
	}
	
	function get_property_ownership_score($value,$product,$sub_product)
	{
		if($product=='REGULAR_old') {
		
		if($value=='Self Owned') { $expected_to_score='10';}
		elseif($value=='Spouse') { $expected_to_score='8';	}		
		elseif($value=='Parents/son') { $expected_to_score='6';	}		
		elseif($value=='Other') { $expected_to_score='4';	}		
		
		}
		return $expected_to_score;
		
	}
	
	function get_type_city_score($value,$product,$sub_product)
	{
		if($product=='REGULAR_old') {
		
		if($value=='Mini Metro') { $expected_to_score='10';}
		elseif($value=='Tier I') { $expected_to_score='8';	}		
		elseif($value=='Tier II') { $expected_to_score='6';	}		
		elseif($value=='Village') { $expected_to_score='4';	}		
		
		}
		return $expected_to_score;
		
	}
	
	
	function get_title_search_score($value,$product,$sub_product)
	{
		if($product=='REGULAR_old') {
		
		if($value=='Clear') { $expected_to_score='8';}
		elseif($value=='Devaitions are there in the same') { $expected_to_score='0';	}		
		}
		return $expected_to_score;
		
	}
	
	function get_standard_coll_score($value,$product,$sub_product)
	{
		if($product=='REGULAR_old') {
		
		if($value=='Yes') { $expected_to_score='8';}
		elseif($value=='No') { $expected_to_score='3';	}		
		}
		return $expected_to_score;
		
	}
	
	function get_ltv_score($value,$product,$sub_product)
	{
		if($product=='REGULAR_old') {
		
		if($value=='No') { $expected_to_score='8';}
		elseif($value>5 || $value <=10) { $expected_to_score='5';	}		
		elseif($value>10) { $expected_to_score='0';	}		
		}
		return $expected_to_score;
		
	}
		
	function get_internal_rating($dealer_code,$score,$product){
		
		if(in_array($product,$this->sahaj_pargati())){
			
			if($score>80){$category='A';}
			elseif($score>60 && $score <=80) { $category='B'; }
			elseif($score>50 && $score <=60) { $category='C'; }
			elseif($score>40 && $score <=50) { $category='D'; }
			elseif($score>0 && $score <=40) { $category='E'; }
			
			return $category;
		}
		
	}
	
	function get_cam_entry_values($dealer_code,$cam_id,$link)
	{
		//return $cam=$this->select("*","df_cam_entry","cam_entry_id='$cam_id' AND fk_dealer_code='$dealer_code'",$link);	
		return $cam=$this->select("*","df_cam_entry","cam_entry_id='$cam_id' AND fk_dealer_code='$dealer_code'",$link);	
	}
	
	function get_cam_entry_values_history($dealer_code,$cam_id,$link)
	{
		//return $cam=$this->select("*","df_cam_entry","cam_entry_id='$cam_id' AND fk_dealer_code='$dealer_code'",$link);	
		return $cam=$this->select("*","df_cam_entry_history","cam_entry_id='$cam_id' AND fk_dealer_code='$dealer_code'",$link);	
	}
	
	function BAccountType($status=FALSE) {
		
		//echo $status;
		$cam=new cam();	
		$fflist.="<option value=''>-A/c type-</option>";	
		$fflist.= "<option value=\"CA\" ".$cam->CheckSelected($status,'CA','select').">CA</option>";
		$fflist.= "<option value=\"CC\" ".$cam->CheckSelected($status,'CC','select').">CC</option>";
		$fflist.= "<option value=\"TL\" ".$cam->CheckSelected($status,'TL','select').">TL</option>";
		$fflist.= "<option value=\"OD\" ".$cam->CheckSelected($status,'OD','select').">OD</option>";
		$fflist.= "<option value=\"SB\" ".$cam->CheckSelected($status,'SB','select').">SB</option>";
		return $fflist;
	}
	
	function BYearMonth($status=FALSE) {
		
		$start = new DateTime("2013-01-01");
		$interval = new DateInterval('P1M');
		$end = new DateTime(Date('Y-m-d'));
		$period = new DatePeriod($start, $interval, $end);

		foreach ($period as $dt) {
			$ccperiod[]["cc_period"]=$dt->format('M-y');
		}
		
		return $ccperiod;

	}
	
	function OwnershipList($status=FALSE){
		
		$cam=new cam();	
		$loan_type_array=array('Individual','Guarantor','Joint');
		$fflist.="<option value=''>-Select-</option>";		foreach($loan_type_array as $lt){
			
			$fflist.= "<option value=\"$lt\" ".$cam->CheckSelected($status,"$lt",'select').">$lt</option>";
			
		}
		return $fflist;		
	}
	
	function LoanType($status=FALSE){
		
		$cam=new cam();	
		$loan_type_array=array('Cash Credit','Cash Credit-Agri','Gold Loan','Housing Loan','Personal Loan','Education Loan','Auto Loan','Property Loan','Commercial Vehicle Loan','Business Term Loan','Credit Card','Other Loans');
		$fflist.="<option value=''>-Loan Type-</option>";		
		foreach($loan_type_array as $lt){
			
			$fflist.= "<option value=\"$lt\" ".$cam->CheckSelected($status,"$lt",'select').">$lt</option>";
			
		}
		return $fflist;		
	}
	
	function CollAssetClass($status=FALSE){
		
		$cam=new cam();	
		$type_array=array('LIQUID COLLATERALS','MOVABLE','IMMMOVABLE ASSETS','CURRENT ASSETS');
		$fflist.="<option value=''>-Select-</option>";		foreach($type_array as $lt){
			
			$fflist.= "<option value=\"$lt\" ".$cam->CheckSelected($status,"$lt",'select').">$lt</option>";
			
		}
		return $fflist;		
	}
	
	function CollResidential($status=FALSE){
		
		$cam=new cam();	
		$type_array=array('Self occupied Residential/Commercial','Rented Residential / Commercial','Agriculture land','Residential Plot','Any other type of asset');
		$fflist.="<option value=''>-Select-</option>";		foreach($type_array as $lt){
			
			$fflist.= "<option value=\"$lt\" ".$cam->CheckSelected($status,"$lt",'select').">$lt</option>";
			
		}
		return $fflist;		
	}
	
	function CollUsageProperty($status=FALSE){
		
		$cam=new cam();	
		$type_array=array('Residential in municipal limit','Commercial','Industry/Factory/godown','Self-occupied - Residential + commercial property','Rented - Residential + Commercial','Residential Plot (NA)','Agricultural land');
		$fflist.="<option value=''>-Select-</option>";		foreach($type_array as $lt){
			
			$fflist.= "<option value=\"$lt\" ".$cam->CheckSelected($status,"$lt",'select').">$lt</option>";
			
		}
		return $fflist;		
	}
	
	function CollOwnerProperty($status=FALSE){
		
		$cam=new cam();	
		$type_array=array('Self Owned','Spouse','Parents','Other');
		$fflist.="<option value=''>-Select-</option>";		foreach($type_array as $lt){
			
			$fflist.= "<option value=\"$lt\" ".$cam->CheckSelected($status,"$lt",'select').">$lt</option>";
			
		}
		return $fflist;		
	}
	
	

	function get_coll_totalvalue_finalvalue($dealer_code,$link){
		
		$total_value=$this->select("sum(detail_one) + sum(detail_two) + sum(detail_three) as total_value ","df_cam_colllteral_details","fk_dealer_code='$dealer_code' AND cd_list LIKE '%TOTAL Value as per Valuation%'",$link);
		
		$final_value=$this->select("sum(detail_one) + sum(detail_two) + sum(detail_three) as final_value ","df_cam_colllteral_details","fk_dealer_code='$dealer_code' AND cd_list LIKE '%Final Value of the property considered%'",$link);
		
		return array("total_value"=>$total_value[0]["total_value"],"final_value"=>$final_value[0]["final_value"]);
		
	}
	
	
	function get_banking_total($dealer_code,$link){
		
		$b=$this->select("sum(month1) as banking_total","df_cam_bank_details","fk_dealer_code='$dealer_code' AND month_year like '%Min of Total%'",$link);
		return $b[0]["banking_total"];
	}
	
	
	function get_dfr_incremental_projected_to($dealer_code,$link){
		
		$ced=$this->get_cam_entry_values($dealer_code,$_GET["cam_id"],$link);
		$requested_loan_amount=$ced[0]["requested_loan_amount"];
		
		$cam=new cam();		
		$incremental_projected_to=$requested_loan_amount*(12/$cam->CCAVGCC($link,$dealer_code));
		return $incremental_projected_to;
	}
	
	function get_dfr_final_projected_to($dealer_code,$link){
		
		$ced=$this->get_cam_entry_values($dealer_code,$_GET["cam_id"],$link);
		$requested_loan_amount=$ced[0]["requested_loan_amount"];
		
		$mpf=$this->select("year_three","df_cam_mpf","fk_dealer_code='$dealer_code' AND mpf_assessment like '%Capital Amount (Ps enter the share capital+reserve & surplus )%'",$link);
		$mpf_capital_amt=$mpf[0]["year_three"]*100000;
		
		$loans=$this->select("sum(a.loan_amount) as total_loans","(SELECT * FROM `df_cam_loans` where fk_dealer_code='$dealer_code' and loan_amount!='' order by loans_id desc limit 2) as a","1",$link);
	
		$total_loans=$loans[0]["total_loans"];
		
		$finance=$this->select("year3","df_cam_financial","fk_dealer_code='$dealer_code' AND financial_data='13'",$link);
		
		$pat=(int)$finance[0]["year3"]*100000;
		
		$cam=new cam();
		//$cam->CCAVGCC($dealer_code);
		
		$final_projected_to=($requested_loan_amount+$mpf_capital_amt+$pat+$total_loans)*$cam->CCAVGCC($link,$dealer_code);
		return $final_projected_to;
		
	}
	
	function get_total_netincome_niipl($dealer_code,$link){
			
		$final_projected=$this->get_dfr_final_projected_to($dealer_code,$link);
		
		$final_projected_per=$final_projected*10/100;
		
		$tv_actual_amt=$this->select("actual_amt","df_cam_targetvsachived","fk_dealer_code='$dealer_code' limit 1,1",$link);
		$p_actual_amt=$this->select("actual_amt","df_cam_targetvsachived","fk_dealer_code='$dealer_code' limit 2,2",$link);
		$actual_amt=$tv_actual_amt[0]["actual_amt"]*10/100;
		$p_actual_amt=(float)$p_actual_amt[0]["actual_amt"]*10/100;
		
		$cam=new cam();
		
		if($p_actual_amt!="" && $final_projected_per!=""){
		$projected=$cam->maximum(array($p_actual_amt,$final_projected_per));		
		}
		return array("annual_income"=>$actual_amt,"projected_analysis"=>$projected);
		
	}
	
	function get_total_allied_income($dealer_code,$link){
		
		return $total_allied=$this->select("SUM(allied_activity_listamt) as annual_income,SUM(allied_activity_final_amt) as projected_analysis","df_cam_allied_activity","fk_dealer_code='$dealer_code'",$link);
				
	}
	
	function get_total_other_income($dealer_code,$link){
		
		return $total_other_income=$this->select("SUM(other_income_listamt) as annual_income,SUM(other_income_final_amt) as projected_analysis","df_cam_other_income","fk_dealer_code='$dealer_code'",$link);
		
	}
	
	function get_total_otherhh_income($dealer_code,$link){
		
		return $total_otherhh_income=$this->select("SUM(otherhh_income_listamt) as annual_income,SUM(otherhh_income_final_amt) as projected_analysis","df_cam_otherhh_income","fk_dealer_code='$dealer_code'",$link);
	}
	
	function get_total_income_applicant($dealer_code,$link){
		
		$A=$this->get_total_netincome_niipl($dealer_code,$link);
		$B=$this->get_total_allied_income($dealer_code,$link);
		$C=$this->get_total_other_income($dealer_code,$link);
		$D=$this->get_total_otherhh_income($dealer_code,$link);
		$total_applicant_net_income=$A["annual_income"]+$B[0]["annual_income"]+$C[0]["annual_income"]+$D[0]["annual_income"];
		$total_applicant_projected_income=$A["projected_analysis"]+$B[0]["projected_analysis"]+$C[0]["projected_analysis"]+$D[0]["projected_analysis"];
		
		return array("total_applicant_net_income"=>$total_applicant_net_income,"total_applicant_projected_income"=>$total_applicant_projected_income);
		
	}
	
	function get_total_coapp_income($dealer_code,$link){
		
		return $total_coapp_income=$this->select("SUM(coapp_income_listamt) as annual_income,SUM(coapp_income_final_amt) as projected_analysis","df_cam_coapp_income","fk_dealer_code='$dealer_code'",$link);
	}
	
	function get_income_applicant_coapplicant($dealer_code,$link){
		
		$A=$this->get_total_income_applicant($dealer_code,$link);
		$B=$this->get_total_coapp_income($dealer_code,$link);
		
		$total_app_coapp_income=$A["total_applicant_net_income"]+$B[0]["annual_income"];
		$total_app_coapp_projected=$A["total_applicant_projected_income"]+$B[0]["projected_analysis"];
		
		return array("total_app_coapp_income"=>$total_app_coapp_income,"total_app_coapp_projected"=>$total_app_coapp_projected);
		
	}
	
	function get_total_applicant_obligation($dealer_code,$link){
		
		return $total_obligation=$this->select("SUM(annual_expense + annual_emi_obligation + annual_wc_obligation + annual_pending_obligation + annual_interest_obligation) as total_obligation_income, SUM(projected_expense + projected_emi_obligation + projected_wc_obligation + projected_pending_obligation + projected_interest_obligation) as total_obligation_projected","df_cam_obligation","fk_dealer_code='$dealer_code' AND obligation_type=0",$link);
		
	//return	array("total_obligation_income"=>$total_obligation[0]["total_obligation_income"],"total_obligation_projected"=>$total_obligation[0]["total_obligation_projected"]);
		
	}
	
	function get_total_coapplicant_obligation($dealer_code,$link){
		
		return $total_obligation=$this->select("SUM(annual_expense + annual_emi_obligation + annual_wc_obligation + annual_pending_obligation + annual_interest_obligation) as total_obligation_income, SUM(projected_expense + projected_emi_obligation + projected_wc_obligation + projected_pending_obligation + projected_interest_obligation) as total_obligation_projected","df_cam_obligation","fk_dealer_code='$dealer_code' AND obligation_type=1",$link);
		
	//return	array("total_obligation_income"=>$total_obligation[0]["total_obligation_income"],"total_obligation_projected"=>$total_obligation[0]["total_obligation_projected"]);
		
	}
	
	function get_total_app_coapp_obligation($dealer_code,$link){
		$A=$this->get_total_applicant_obligation($dealer_code,$link);
		$B=$this->get_total_coapplicant_obligation($dealer_code,$link);
		
		return array("total_appcoaap_obligation_income"=>$A[0]["total_obligation_income"]+$B[0]["total_obligation_income"],"total_appcoaap_obligation_projected"=>$A[0]["total_obligation_projected"]+$B[0]["total_obligation_projected"]);
		
	}
	
	function get_income_after_obligation($dealer_code,$link){
		
		$cam=new cam();
		$A=$this->get_income_applicant_coapplicant($dealer_code,$link);
		$B=$this->get_total_app_coapp_obligation($dealer_code,$link);
			
		if($B["total_appcoaap_obligation_income"]!="" && $B["total_appcoaap_obligation_projected"]!=""){	
		return array("total_income_after_obligation"=>$A["total_app_coapp_income"]-$B["total_appcoaap_obligation_income"],"total_projected_after_obligation"=>$A["total_app_coapp_projected"]-$B["total_appcoaap_obligation_projected"],"expense_ration_income"=>$cam->make_roundoff_two($A["total_app_coapp_income"]/$B["total_appcoaap_obligation_income"]),"expense_ration_projected"=>$cam->make_roundoff_two($A["total_app_coapp_projected"]/$B["total_appcoaap_obligation_projected"]));
		}
	}
	
	

	function get_incremental_final_projected_to_loan_cash_cycle($dealer_code,$cam_id,$link){
		$cam_entry=$this->get_cam_entry_values($dealer_code,$cam_id,$link);
		$requested_loan_amount=$cam_entry[0]["requested_loan_amount"];
		
		//$to_niipl_next_year=$this->select("projection_amt","df_cam_targetvsachived","fk_dealer_code='$dealer_code' order by dfcamtva_id DESC limit 1",$link);
		//$to_niipl_next_year_val=$to_niipl_next_year[0]["projection_amt"];

		/*prachee -14-may-2019*/
		$pri_year = date("Y",strtotime("-1 year"));
		$search_pri_year ='Year '.$pri_year;
		$to_niipl_next_year=$this->select("projection_amt","df_cam_targetvsachived","(fk_dealer_code='$dealer_code' && target_achived_year='$search_pri_year' )",$link);
		$to_niipl_next_year_val=$to_niipl_next_year[0]["projection_amt"];


		$to_niipl_last_year=$this->select("projection_amt,actual_amt","df_cam_targetvsachived","fk_dealer_code='$dealer_code' order by dfcamtva_id DESC limit 1,1",$link); // change projection_amt to actual_amt -Requested by neha thakur - 20-7-2019
		//$to_niipl_last_year_val=$to_niipl_last_year[0]["projection_amt"];

		$to_niipl_last_year_val=$to_niipl_last_year[0]["actual_amt"];
		
		$cnmpf=$this->select("year_one","df_cam_mpf_next","fk_dealer_code='$dealer_code' AND mpfn_assessment LIKE '%Final projected TO for Current year%' ",$link);

		$final_projected_to_for_current_year=$cnmpf[0]["year_one"] * 100000; //Prachee-Requested by neha thakur - 20-7-2019
		if($final_projected_to_for_current_year =="" )
		{
			$final_projected_to_for_current_year=0;
		}

		$cam=new cam();
		//$cam->CCAVGCC($dealer_code);
		$incremental_projected_to_loan_cash_cycle=$requested_loan_amount*(12/$cam->CCAVGCC($link,$dealer_code));
		
		if(trim($incremental_projected_to_loan_cash_cycle)=="INF")
		{
			$incremental_projected_to_loan_cash_cycle =0;
		}
		$incremental_final_projected_to_loan_cash_cycle=$to_niipl_next_year_val+$incremental_projected_to_loan_cash_cycle;
		
		return array('to_niipl_next_year_val'=>$to_niipl_next_year_val,'to_niipl_last_year_val'=>$to_niipl_last_year_val,'incremental_projected_to_loan_cash_cycle'=>$incremental_projected_to_loan_cash_cycle,'incremental_final_projected_to_loan_cash_cycle'=>$incremental_final_projected_to_loan_cash_cycle,'final_projected_to_for_current_year'=>$final_projected_to_for_current_year);
		
		//loan_amt(12/cc)
		//tva+incremental
	}
	function get_incremental_final_projected_to_loan_cash_cycle_history($dealer_code,$cam_id,$link){
		$cam_entry=$this->get_cam_entry_values_history($dealer_code,$cam_id,$link);
		$requested_loan_amount=$cam_entry[0]["requested_loan_amount"];
		$to_niipl_next_year=$this->select("projection_amt","df_cam_targetvsachived_history","fk_dealer_code='$dealer_code' order by dfcamtva_id DESC limit 1",$link);
		$to_niipl_next_year_val=$to_niipl_next_year[0]["projection_amt"];
		$to_niipl_last_year=$this->select("projection_amt","df_cam_targetvsachived_history","fk_dealer_code='$dealer_code' order by dfcamtva_id DESC limit 1,1",$link);
		$to_niipl_last_year_val=$to_niipl_last_year[0]["projection_amt"];
		
		$cam=new cam();
		//$cam->CCAVGCC($dealer_code);
		$incremental_projected_to_loan_cash_cycle=$requested_loan_amount*(12/$cam->CCAVGCC($link,$dealer_code));
		
		$incremental_final_projected_to_loan_cash_cycle=$to_niipl_next_year_val+$incremental_projected_to_loan_cash_cycle;
		
		return array('to_niipl_next_year_val'=>$to_niipl_next_year_val,'to_niipl_last_year_val'=>$to_niipl_last_year_val,'incremental_projected_to_loan_cash_cycle'=>$incremental_projected_to_loan_cash_cycle,'incremental_final_projected_to_loan_cash_cycle'=>$incremental_final_projected_to_loan_cash_cycle);
		
		//loan_amt(12/cc)
		//tva+incremental
	}
	
	
	function get_final_loan_eligibility_details($link,$dealer_code,$cam_id,$product){
		
		$cam_entry=$this->get_cam_entry_values($dealer_code,$cam_id,$link);		
		$cam=new cam();		
		switch($product){
			case 'SAHAJ':
			case 'SAHAJ CMT':
			case 'PRAGATI':
			case 'BL':
			case 'FBL':
			case 'REGULAR':
			
			$mpfucftn_q=$this->select("year_one","df_cam_mpf_next","fk_dealer_code='$dealer_code' AND mpfn_assessment='Max Permissible Finance'",$link);

			$mpfucftn=$mpfucftn_q[0]["year_one"]*100000;

			$mpf1=$this->select("year_one","df_cam_mpf_next","fk_dealer_code='$dealer_code' AND mpfn_assessment LIKE '%Projected Turnover ( Net of sales returns etc. )%'",$link);

			$mpf2=$this->select("year_one","df_cam_mpf_next","fk_dealer_code='$dealer_code' AND mpfn_assessment LIKE '%The turnover considered acceptable by the appraising authority for the instant appraisal considering ,inter-alia ,the relevant figures under A-1 & A-2 above and other justifications (to be specified )if any.%'",$link);

			
			//echo "*****".$mpf1[0]["year_one"]."=====".$mpf2[0]["year_one"];
			//sahaj
			if($mpf1[0]["year_one"]!="" && $mpf2[0]["year_one"]!="")
			{
				$melup20per=$cam->maximum(array($mpf1[0]["year_one"],$mpf2[0]["year_one"]))*50/100*100000; //Prachee - Requested by Trishant - 27-jun-2019
			}
			//echo "++++++".$mpfucftn."++++++".$melup20per."++++++".$cam_entry[0]["requested_loan_amount"];
			//echo "=======".$mpf1[0]["year_one"],"====".$mpf2[0]["year_one"];
			//exit;

			//echo "*********".$mpf1[0]["year_one"]."******".$mpf2[0]["year_one"];

		//echo "+++++++++".$mpfucftn."==".$melup20per."====".$cam_entry[0]["requested_loan_amount"];
			if($cam_entry[0]["requested_loan_amount"]!=''){
				$final_loan_eligibility=$cam->minimum(array($mpfucftn,$melup20per,$cam_entry[0]["requested_loan_amount"]));
			}			
			return array('max_permissible_finance_under_cash'=>$mpfucftn,'maximum_eligible_loan_upto'=>$melup20per,'requested_loan_amount'=>$cam_entry[0]["requested_loan_amount"],'loan_amt_proposed'=>$final_loan_eligibility,'final_loan_eligibility'=>$final_loan_eligibility);
		
			
				break;
		case 'REGULAR_old':
			
			$mpfucftn_q=$this->select("year_one","df_cam_mpf_next","fk_dealer_code='$dealer_code' AND mpfn_assessment='Max Permissible Finance'",$link);

			$mpfucftn=$mpfucftn_q[0]["year_one"]*100000;

			$mpf1=$this->select("year_one","df_cam_mpf_next","fk_dealer_code='$dealer_code' AND mpfn_assessment LIKE '%The turnover considered acceptable by the appraising authority for the instant appraisal considering ,inter-alia ,the relevant figures under A-1 & A-2 above and other justifications (to be specified )if any.%'",$link);

			$mpf2=$this->select("year_one","df_cam_mpf_next","fk_dealer_code='$dealer_code' AND mpfn_assessment LIKE '%Total Working capital loans already Availed%'",$link);


			$melup40per=($mpf1[0]["year_one"]*40/100-$mpf2[0]["year_one"])*100000;

			$coll_det=$this->select("detail_one","df_cam_colllteral_details","fk_dealer_code='$dealer_code' AND cd_list LIKE '%Total value of Security provided%'",$link);

			$mebltvpv=$coll_det[0]["detail_one"];
			$larba= $cam_entry[0]["requested_loan_amount"];

			$final_loan_eligibility=$cam->minimum(array($mpfucftn,$melup40per,$mebltvpv,$larba));
			
			return array('loan_amt_proposed'=>$final_loan_eligibility,'final_loan_eligibility'=>$final_loan_eligibility);
			
			default:
				break;
		}
		
		
	}
	
	function get_collateral_details($product_name){
		
		if($product_name=='SAHAJ' || $product_name=='SAHAJ CMT' || $product_name=='BL' || $product_name=='FBL' || $product_name=='REGULAR'){
			return array('standard_collateral'=>10,'proposed_collateral'=>10);
		}
		elseif($product_name=='PRAGATI'){
			return array('standard_collateral'=>50,'proposed_collateral'=>50);
		}
	}
	
	function get_cam_approval_name($email_id){
		
		$email=explode('@',$email_id);
		$email_name=explode('.',$email[0]);
		return $user_name=ucwords($email_name[0]." ".$email_name[1]);
		
	}
	
	function get_user_name($email_id,$link){
		
		$ud=$this->select("asset_admin_username","asset_admin_master","dealer_email='$email_id'",$link);		
		return $user_name=$ud[0]["asset_admin_username"];
		
	}
	
	function get_cam_approval_email($user_name,$link){
		
		$ud=$this->select("dealer_email","asset_admin_master","asset_admin_username='$user_name'",$link);		
		return $user_name=$ud[0]["dealer_email"];
	}
	
	function check_cam_approval_user($dealer_code,$cam_id,$approver_name,$link){
		
		$uans=$this->select("*","df_cam_approval","fk_cam_id='$cam_id' AND fk_dealer_code='$dealer_code' AND cam_approval_user='$approver_name'",$link);	
		
		if($uans[0]["cam_approval_status"]=='CAM Approval Sent'){
			
			return $this->create_anchor("href='javascript:;' target='_blank' onclick='dfcamrecommend($dealer_code,$cam_id); ' class='a_point  label label-success'",'Recommend for Approval');
			
		}			
		elseif($uans[0]["cam_approval_status"]=='CAM Recommend for Approval'){
			
			return $this->create_anchor("href='javascript:;' target='_blank' class='a_point  label label-success'",'Send for Approval');
		
		}	
        	
	}
	
	function get_int_expence_ration($dealer_code,$cam_id,$product,$link){
		
		
		$cam=new cam();
		$cam_loans=$this->select("SUM(emi_amount) as total_emi_amount, SUM(loan_pos) as total_pos","df_cam_loans","fk_dealer_code='$dealer_code'",$link);
		$total_emi_amount=$cam_loans[0]["total_emi_amount"];
		
		$incremental_final_projected_to_loan_cash_cycle=$this->get_incremental_final_projected_to_loan_cash_cycle($dealer_code,$cam_id,$link);
		
		$finan=$this->select("*","df_cam_targetvsachived","fk_dealer_code='$dealer_code'",$link);
		
		$fnet_income_niipl=$finan[1][6]*10/100;
		$fnet_income=$cam->make_roundoff($incremental_final_projected_to_loan_cash_cycle["incremental_final_projected_to_loan_cash_cycle"]*10/100);

		if(trim($fnet_income)=="INF")
		{
			$fnet_income=0;  // prachee -4-april-2019
		}

		$pd_details=$this->select("*","df_cam_pd_details","fk_dealer_code='$dealer_code'",$link);
		
		//Total income
		$f_total_income=$fnet_income_niipl+$fnet_income+$pd_details[0]["pd_agricultural"]+$pd_details[0]["pd_rent"]+$pd_details[0]["pd_income_other"];
		
		$proposed_loan_details=$this->select("*","df_cam_proposed_loan_details","fk_dealer_code='$dealer_code' ",$link);
		$f_obli = (float)$proposed_loan_details[0]["loan_amt_proposed"]*16.5/100;
		
		//Total Expenses
		$f_total_expen=$pd_details[0]["pd_expence_total"]+$f_obli+$total_emi_amount;
		
		//NET ANNUAL INCOME OF THE APPLICANT
		$net_annual=$f_total_income-$f_total_expen;
		
		//Interest Coverage Ratio
		$i_c_r =($total_emi_amount+$f_obli);
		if($i_c_r>0){
		$interest_coverage_ratio=$cam->make_roundoff_two($net_annual/($total_emi_amount+$f_obli));
		}
		
		//Expense coverage ratio
		$expense_coverage_ratio=$cam->make_roundoff_two($f_total_expen/$f_total_income);
		
		//Debt Equity ratio
		$debt_equity_ratio=$cam->make_roundoff_two($cam_loans[0]["total_pos"]/$pd_details[0]["pd_capital"]);
		
		return array('interest_coverage_ratio'=>$interest_coverage_ratio,'expense_coverage_ratio'=>$expense_coverage_ratio,'debt_equity_ratio'=>$debt_equity_ratio);
		
		
	
		
	}
	
	function check_dealer_exist($dealer_code,$link){
		$dm=$this->select("dealer_code","dealer_info_master","dealer_code='$dealer_code'",$link);
		if(!$dm){
			$this->set_flash("msgwarning","Dealer does not exist in dealer master!","list_df_cam_approval.php");
		}
	}
	
	
}

$dfcam=new dfcam();
?>