<?php
function naf_checkRequiredPost($requiredField) {
	$numRequired = count($requiredField);
	$keys        = array_keys($_POST);
	
	$allFieldExist  = true;
	for ($i = 0; $i < $numRequired && $allFieldExist; $i++) {
		if (!in_array($requiredField[$i], $keys) || $_POST[$requiredField[$i]] == '') {
			$allFieldExist = false;
		}
	}
	
	return $allFieldExist;
}



function naf_queryString()
{
	$qString = array();
	
	foreach($_GET as $key => $value) {
		if (trim($value) != '') {
			$qString[] = $key. '=' . trim($value);
		} else {
			$qString[] = $key;
		}
	}
	
	$qString = implode('&', $qString);
	
	return $qString;
}

/**************************
	Paging Functions
***************************/

function naf_getPagingQuery($sql, $itemPerPage = 10,$newpagenumber='')
{

	 if($newpagenumber=="")
	{
		if(isset($_GET['page']))
		{
			$newpagenumber=$_GET['page'];
		}
		else
		{
			$newpagenumber="";
		}
	}

	/*if (isset($_GET['page']) && (int)$_GET['page'] > 0) {
		$page = (int)$_GET['page'];
	} else {
		$page = 1;
	}*/

	if ($newpagenumber > 0) {
		$page = $newpagenumber;//(int)$_GET['page'];
	} else {
		$page = 1;
	}
	
	// start fetching from this row number
	$offset = ($page - 1) * $itemPerPage;
	
	return $sql . " LIMIT $offset, $itemPerPage";
}

/*
	Get the links to navigate between one result page to another.
	Supply a value for $strGet if the page url already contain some
	GET values for example if the original page url is like this :
	
	http://www.phpwebcommerce.com/plaincart/index.php?c=12
	
	use "c=12" as the value for $strGet. But if the url is like this :
	
	http://www.phpwebcommerce.com/plaincart/index.php
	
	then there's no need to set a value for $strGet
	
	
*/
function naf_getPagingLink($sql, $itemPerPage = 10, $strGet = '',$newpagenumber ='')
{

	$result        = mysql_query($sql);
	$pagingLink    = '';
	$totalResults  = mysql_num_rows($result);
	$totalPages    = ceil($totalResults / $itemPerPage);
	
	// how many link pages to show
	$numLinks      = 7;
	 if($newpagenumber=="")
	{
		$newpagenumber=$_GET['page'];
	}
		
	// create the paging links only if we have more than one page of results
	if ($totalPages > 1) {
	
		$self = 'http://' . $_SERVER['HTTP_HOST'] . $_SERVER['PHP_SELF'] ;
		

		//if (isset($_GET['page']) && (int)$_GET['page'] > 0) {
		if ($newpagenumber > 0) {
			$pageNumber = $newpagenumber;//(int)$_GET['page'];
		} else {
			$pageNumber = 1;
		}
		
		// print 'previous' link only if we're not
		// on page one
		if ($pageNumber > 1) {
			$page = $pageNumber - 1;
			if ($page > 1) {
				$prev = "<a  href=\"$self?page=$page&$strGet\">Previous</a>&nbsp;&nbsp;";
			} else {
				$prev = "<a href=\"$self?$strGet\">Previous</a>&nbsp;&nbsp;";
			}	
				
			$first = '<span style="padding-right:7px;float:left;"> <a style="color:blue;font-family:Tahoma;font-size:12px;" href=\"$self?$strGet\">[First]</a></div>';
		} else {
			$prev  = '<span class="disabled">Previous</span>&nbsp;&nbsp;'; // we're on page one, don't show 'previous' link
			$first = '<span class="disabled">First</span>'; // nor 'first page' link
		}
	
		// print 'next' link only if we're not
		// on the last page
		if ($pageNumber < $totalPages) {
			$page = $pageNumber + 1;
			$next = "&nbsp;&nbsp;<a href=\"$self?page=$page&$strGet\">Next</a>&nbsp;&nbsp;";
			$last = "<a href=\"$self?page=$totalPages&$strGet\">[Last]</a>";
		} else {
			$next = '&nbsp;&nbsp;<span class="disabled">Next</span>&nbsp;&nbsp;&nbsp;&nbsp;'; // we're on the last page, don't show 'next' link
			$last = '<span class="disabled">Last</span>&nbsp;&nbsp;&nbsp;&nbsp;'; // nor 'last page' link
		}
		$start = $pageNumber - ($pageNumber % $numLinks) + 1;
		$end   = $start + $numLinks - 1;		
		
		$end   = min($totalPages, $end);
		
		$pagingLink = array();
		for($page = $start; $page <= $end; $page++)	{
			if ($page == $pageNumber) {
				if($page < 10)
				{
					$pagingLink[] = " <span class='selected'>$page</span>";   // no need to 
				}
				else
				{
					$pagingLink[] = " <span class='selected'>$page</span>";   // no need to 
				}
				//create a link to current page
			} else {
				if ($page == 1) {
					$pagingLink[] = "<a href=\"$self?$strGet\">$page</a>";
				} else {	
					if($page < 10)
					{
						$pagingLink[] = "<a href=\"$self?page=$page&$strGet\">$page</a>";
					}
					else
					{
						$pagingLink[] = "<a href=\"$self?page=$page&$strGet\">$page</a>";


					}
				}	
			}
	
		}
		
		//$pagingLink ="<b>Paging<b>&nbsp;&nbsp;". implode(' | ', $pagingLink);
		$pagingLink =implode('&nbsp;&nbsp;', $pagingLink);
		 
		// return the page navigation link
		$pagingLink =$prev.$pagingLink.$next;
	}
	
	return $pagingLink;
}

function naf_getPagingLinkFront($sql, $itemPerPage = 10, $strGet = '',$newpagenumber ='')
{

	//$result        = mysql_query($sql);
	$pagingLink    = '';
	$totalResults=$sql;
	$totalPages    = ceil($totalResults / $itemPerPage);
	
	// how many link pages to show
	$numLinks      = 7;
	 if($newpagenumber=="")
	{
		$newpagenumber=$_GET['page'];
	}
		
	// create the paging links only if we have more than one page of results
	if ($totalPages > 1) {
	
		$self = 'http://' . $_SERVER['HTTP_HOST'] . $_SERVER['PHP_SELF'] ;
		

		//if (isset($_GET['page']) && (int)$_GET['page'] > 0) {
		if ($newpagenumber > 0) {
			$pageNumber = $newpagenumber;//(int)$_GET['page'];
		} else {
			$pageNumber = 1;
		}
		
		// print 'previous' link only if we're not
		// on page one
		if ($pageNumber > 1) {
			$page = $pageNumber - 1;
			if ($page > 1) {
				$prev = "<a  href=\"$self?page=$page&$strGet\">Previous</a>&nbsp;&nbsp;";
			} else {
				$prev = "<a href=\"$self?$strGet\">Previous</a>&nbsp;&nbsp;";
			}	
				
			$first = '<span style="padding-right:7px;float:left;"> <a style="color:blue;font-family:Tahoma;font-size:12px;" href=\"$self?$strGet\">[First]</a></div>';
		} else {
			$prev  = '<span class="disabled">Previous</span>&nbsp;&nbsp;'; // we're on page one, don't show 'previous' link
			$first = '<span class="disabled">First</span>'; // nor 'first page' link
		}
	
		// print 'next' link only if we're not
		// on the last page
		if ($pageNumber < $totalPages) {
			$page = $pageNumber + 1;
			$next = "&nbsp;&nbsp;<a href=\"$self?page=$page&$strGet\">Next</a>&nbsp;&nbsp;";
			$last = "<a href=\"$self?page=$totalPages&$strGet\">[Last]</a>";
		} else {
			$next = '&nbsp;&nbsp;<span class="disabled">Next</span>&nbsp;&nbsp;&nbsp;&nbsp;'; // we're on the last page, don't show 'next' link
			$last = '<span class="disabled">Last</span>&nbsp;&nbsp;&nbsp;&nbsp;'; // nor 'last page' link
		}
		$start = $pageNumber - ($pageNumber % $numLinks) + 1;
		$end   = $start + $numLinks - 1;		
		
		$end   = min($totalPages, $end);
		
		$pagingLink = array();
		for($page = $start; $page <= $end; $page++)	{
			if ($page == $pageNumber) {
				if($page < 10)
				{
					$pagingLink[] = " <span class='selected'>$page</span>";   // no need to 
				}
				else
				{
					$pagingLink[] = " <span class='selected'>$page</span>";   // no need to 
				}
				//create a link to current page
			} else {
				if ($page == 1) {
					$pagingLink[] = "<a href=\"$self?$strGet\">$page</a>";
				} else {	
					if($page < 10)
					{
						$pagingLink[] = "<a href=\"$self?page=$page&$strGet\">$page</a>";
					}
					else
					{
						$pagingLink[] = "<a href=\"$self?page=$page&$strGet\">$page</a>";


					}
				}	
			}
	
		}
		
		//$pagingLink ="<b>Paging<b>&nbsp;&nbsp;". implode(' | ', $pagingLink);
		$pagingLink =implode('&nbsp;&nbsp;', $pagingLink);
		 
		// return the page navigation link
		$pagingLink =$prev.$pagingLink.$next;
	}
	
	return $pagingLink;
}


function naf_getPagingLinkBackEnd($sqlrowscount, $itemPerPage = 10, $strGet = '',$newpagenumber ='')
{

	//$result        = mysql_query($sql);
	$pagingLink    = '';
	//$totalResults  = mysql_num_rows($result);
	$totalResults=$sqlrowscount;
	$totalPages    = ceil($totalResults / $itemPerPage);
	
	// how many link pages to show
	$numLinks      = 10;
	// if($newpagenumber=="")
	//{
		//$newpagenumber=$_GET['page'];
	//}
	
	
	if (isset($_GET['page']))
	{ 
		 $newpagenumber = $_GET["page"]; 
	} 
	else 
	{ 
		$newpagenumber=""; 
	}

		
	// create the paging links only if we have more than one page of results
	if ($totalPages > 1) {
	
		$self = 'http://' . $_SERVER['HTTP_HOST'] . $_SERVER['PHP_SELF'] ;
		

		//if (isset($_GET['page']) && (int)$_GET['page'] > 0) {
		if ($newpagenumber > 0) {
			$pageNumber = $newpagenumber;//(int)$_GET['page'];
		} else {
			$pageNumber = 1;
		}
		
		// print 'previous' link only if we're not
		// on page one
		if ($pageNumber > 1) {
			$page = $pageNumber - 1;
			if ($page > 1) {
				$prev = "<a  href=\"$self?page=$page&$strGet\">Previous</a>&nbsp;&nbsp;";
			} else {
				$prev = "<a href=\"$self?$strGet\" >Previous</a>&nbsp;&nbsp;";
			}	
				
			$first = "<a href=\"$self?page=1&$strGet\">First</a>&nbsp;&nbsp;";
		} else {
			$prev  = '<a><span class="disabled">Previous</span></a>&nbsp;&nbsp;'; // we're on page one, don't show 'previous' link
			$first = '<a><span class="disabled">First</span></a>&nbsp;&nbsp;'; // nor 'first page' link
		}
	
		// print 'next' link only if we're not
		// on the last page
		if ($pageNumber < $totalPages) {
			$page = $pageNumber + 1;
			$next = "&nbsp;&nbsp;<a href=\"$self?page=$page&$strGet\">Next</a>&nbsp;&nbsp;";
			$last = "<a href=\"$self?page=$totalPages&$strGet\">Last</a>";
		} else {
			$next = '&nbsp;&nbsp;<a><span class="disabled">Next</span></a>&nbsp;&nbsp;'; // we're on the last page, don't show 'next' link
			$last = '<a><span class="disabled">Last</span></a>'; // nor 'last page' link
		}
		$start = $pageNumber - ($pageNumber % $numLinks) + 1;
		$end   = $start + $numLinks - 1;		
		
		$end   = min($totalPages, $end);
		
		$pagingLink = array();
		for($page = $start; $page <= $end; $page++)	{
			if ($page == $pageNumber) {
				if($page < 10)
				{
					$pagingLink[] = "<a href='#' style='color:#FFFFFF; background-color:#707070; border-radius: 3px; border:1px solid #666666;'>$page</a>";   // no need to 
				}
				else
				{
					$pagingLink[] = "<a href='#' style='color:#FFFFFF; background-color:#707070; border-radius: 3px; border:1px solid #666666;'>$page</a>";   // no need to 
				}
				//create a link to current page
			} else {
				if ($page == 1) {
					$pagingLink[] = "<a href=\"$self?$strGet\">$page</a>";
				} else {	
					if($page < 10)
					{
						$pagingLink[] = "<a href=\"$self?page=$page&$strGet\">$page</a>";
					}
					else
					{
						$pagingLink[] = "<a href=\"$self?page=$page&$strGet\">$page</a>";


					}
				}	
			}
	
		}
		
		//$pagingLink ="<b>Paging<b>&nbsp;&nbsp;". implode(' | ', $pagingLink);
		$pagingLink =implode('&nbsp;&nbsp;', $pagingLink);
		 
		// return the page navigation link
		$pagingLink =$first.$prev.$pagingLink.$next.$last;
	}
	
	return $pagingLink;
}

?>