<?php
	session_start();
	header('Content-Type: text/html; charset=ISO-8859-1');
	include("connection/db.php");
	include "inc_function.php";
	include "inc_report.php";
	include "inc_session.php";
	error_reporting(0);
	date_default_timezone_set('Asia/Calcutta');
	$today = date('Y-m-d h-i-s');
	$asset_user_name = $_SESSION['session_dealer_office_name'];
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>Rollback Receipt</title>
<?php include "includes/naf_links.inc.php";?>

</head>
<body>
	<div id="container"> 
		<div class="loading_image"></div>
	    <?php include "inc_main_menu.php";  ?>    	       
		<?php include "inc_message.php";?>
		<div id="container">
			<div>
			  	<h3 class="page_title">Rollback receipts.</h3>
			<div>
				<table>
					<tr>
						<th colspan="6"><center>Search Receipt</center></th>
					</tr>
					<tr>
						<td>Ref No. </td><td><input type="text" name="ref_no" class="ref_no" /></td>
						<td>Branch Code  </td><td><input type="text" name="branch_code" class="branch_code" /></td>
						<td>Amount  </td><td><input type="text" name="amount" class="amount" /></td>
					</tr>
					<tr>
						<td>City  </td><td><input type="text" name="city" class="city" /></td>
						<td>District  </td><td><input type="text" name="district" class="district" /></td>
						<td>State  </td><td><input type="text" name="state" class="state" /></td>
					</tr>
					<tr>
						<td>Identified By  </td><td><input type="text" name="identified_by" class="identified_by" /></td>
						<td>Mapped By  </td><td><input type="text" name="mapped_by" class="mapped_by" /></td>
						<td>Search  </td><td><input type='button' name="search" value="Search" class='search_btn'></td>
					</tr>
				</table>
				<table>
					<tr style="background-color:#b3e5fc;">
						<th>receipts_id</th>
						<th>Receipt_Date</th>
						<th>Description</th>
						<th>Ref No.</th>
						<th>Branch Code</th>
						<th>Amount</th>
						<th>Status</th>
						<th>City</th>
						<th>District</th>
						<th>State</th>
						<th>Bank</th>
						<th>Roll Back</th>
					</tr>
				<?php
					$condition = $_GET['condition'];
					$sql = "SELECT * FROM nafa_unidentified_receipts1 WHERE 1=1 $condition ORDER BY value_date DESC";
					$res = mysqli_query($link,$sql);
					if(mysqli_num_rows($res)>0)
					{
						while($row = mysqli_fetch_array($res))
						{
							if($row['complete_status'] == '0')
							{
								continue;
							}
							else
							{
								
								$unidentified_receipts_id = $row['unidentified_receipts_id'];
								echo "<tr>";
								echo "<td>".$row['unidentified_receipts_id']."</td>";
								echo "<td>".date('d-m-Y', strtotime($row['value_date']))."</td>";
								echo "<td>".$row['description']."</td>";
								echo "<td>".$row['ref_no']."</td>";
								echo "<td>".$row['branch_code']."</td>";
								echo "<td>".$row['amount']."</td>";
								echo "<td>".$row['status']."</td>";
								echo "<td>".$row['city']."</td>";
								echo "<td>".$row['district']."</td>";
								echo "<td>".$row['state']."</td>";
								echo "<td>".$row['bank']."</td>";
								
								if($row['complete_status'] == '1')
								{
									echo "<td><a class='btn btn-info roll_back roll_back_$unidentified_receipts_id' name='$unidentified_receipts_id'>RollBack Identified</a>
									<div class='status_$unidentified_receipts_id'></div>
									</td>";
								}
								else
								if($row['complete_status'] == '2')
								{
									echo "<td><a class='btn btn-reset roll_back roll_back_$unidentified_receipts_id' name='$unidentified_receipts_id'>RollBack Mapped</a>
									<div class='status_$unidentified_receipts_id'></div>
									</td>";
								}
								
								echo "</tr>";
							}
						}
					}
					else
					{
						echo "<tr>";
							echo "<td colspan='15'> No record found.</td>";
						echo "</tr>";
					}
				?>
				</table>
			</div>
		</div>
	</div>
</body>
</html>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
<script>
	$(document).ready(function(){
		$('.search_btn').click(function(){
			var condition = '';
			var ref_no = $('.ref_no').val();
			if(ref_no!='' && ref_no!=null)
			{
				condition += " AND ref_no LIKE '"+'%'+ref_no+'%'+"'";
			}

			var branch_code = $('.branch_code').val();
			if(branch_code!='' && branch_code!=null)
			{
				condition += " AND branch_code LIKE '"+'%'+branch_code+'%'+"'";
			}

			var amount = $('.amount').val();
			if(amount!='' && amount!=null)
			{
				condition += " AND amount LIKE '"+'%'+amount+'%'+"'";
			}

			var city = $('.city').val().toLowerCase();
			if(city!='' && city!=null)
			{
				condition += " AND LOWER(city) LIKE '"+'%'+city+'%'+"'";
			}

			var district = $('.district').val().toLowerCase();
			if(district!='' && district!=null)
			{
				condition += " AND LOWER(district) LIKE '"+'%'+district+'%'+"'";
			}

			var state = $('.state').val().toLowerCase();
			if(state!='' && state!=null)
			{
				condition += " AND LOWER(state) LIKE '"+'%'+state+'%'+"'";
			}

			var identified_by = $('.identified_by').val().toLowerCase();
			//alert(identified_by);return false;
			if(identified_by!='' && identified_by!=null)
			{
				condition += " AND LOWER(identified_by) LIKE '"+'%'+identified_by+'%'+"'";
			}

			var mapped_by = $('.mapped_by').val().toLowerCase();
			if(mapped_by!='' && mapped_by!=null)
			{
				condition += " AND LOWER(mapped_by) LIKE '"+'%'+mapped_by+'%'+"'";
			}

			//alert(condition);return false;
			if((ref_no!='' && ref_no!=null) || (branch_code!='' && branch_code!=null) || (amount!='' && amount!=null) || (city!='' && city!=null) || (district!='' && district!=null) || (state!='' && state!=null) || (identified_by!='' && identified_by!=null) || (mapped_by!='' && mapped_by!=null))
			{
				window.location.assign("acc_rollback_receipts.php?condition="+condition);
			}
			else
			{
				window.location.assign("acc_rollback_receipts.php");
			}			
		});
	});

	$('.roll_back').click(function(){
		var unidentified_receipts_id = $(this).attr('name');
		var r = confirm("Do you really want to roll back this receipt");
		if(r == true)
		{
			var rollback_remark = prompt("Please enter rollback comment:");
			if (rollback_remark == null || rollback_remark == "") 
        	{
		       	return false;
		    } 
		    else
		    {
		    	$.ajax({                //roll back receipt to unidentified receipt
					type : 'post',
					url : 'acc_rollback_receipts_helper.php',
					data : 'unidentified_receipts_id='+unidentified_receipts_id+'&rollback_remark='+rollback_remark,
					success : function(res)
					{
						if(res == "success")
						{
							$('.roll_back_'+unidentified_receipts_id).hide();
							$('.status_'+unidentified_receipts_id).html("<center><h4><b style='color:green;'>Rollback Successfully!</b></h4></center>")
						}
						else
						if(res == "fail")
						{
							$('.status_'+unidentified_receipts_id).html("<center><h4><b style='color:red;'>Failed to  Rollback!</b></h4></center>")
						}
					}
				});
		    }
			
		}
		else
		{
			return false;
		}
	});
</script>