<?php
	session_start();
	header('Content-Type: text/html; charset=ISO-8859-1');
	include("connection/db.php");
	include "inc_function.php";
	include "inc_report.php";
	include "inc_session.php";
	error_reporting(0);
	date_default_timezone_set('Asia/Calcutta');
	$today = date('Y-m-d h-i-s');
	$asset_user_name = $_SESSION['session_dealer_office_name'];

	$errorMessage = '';
	$successMessage = '';
	if (isset($_POST['submit'])) 
	{
	    $i=0; //so we skip first row
	    $file_ext = null;

	    $filename = $_FILES['fileToUpload']['name'];
	    if(empty($filename))
	    {
	    	$errorMessage = 'Please select file to upload unidentified receipts';        //error if file not selected
	    }	
	    else
	    {
	    	$file_ext=strtolower(end(explode('.',$_FILES['fileToUpload']['name'])));
	    	
	    	if($file_ext!='csv')
	    	{
	    		$errorMessage = "Only csv files can be uploaded! Download sample file for your refrence!<br/>
	    			To download sample file <a href='unidentified_receipts/unidentified_receipts.csv' style='color:blue;'> Click here</a>";
	    	}
	    	else
	    	{
	    		$handle = fopen($_FILES['fileToUpload']['tmp_name'], "r");
				
				$i=0;
				while (($data = fgetcsv($handle, 10000, ",")) !== FALSE) 
				{
				 	$i++;
				    if($i==1) continue;

				    $csv_date = strtotime($data[0]);
					$updated_date = date('Y-m-d', $csv_date);

				    $sql_chk = "SELECT * FROM nafa_unidentified_receipts1 WHERE value_date='$updated_date' AND description='$data[1]' AND ref_no='$data[2]' AND amount='$data[4]'";
					$result_chk = mysqli_query($link, $sql_chk);
					if(mysqli_num_rows($result_chk)>0)
					{
						$errorMessage = 'Duplicate receipt found in database.';
						continue;
					}
					$today = date('Y-m-d H:i:s');

					$csv_date = strtotime($data[0]);
					$updated_date = date('Y-m-d', $csv_date);
					//echo $updated_date;exit;
				    $sql = "INSERT INTO nafa_unidentified_receipts1(value_date,description,ref_no,branch_code,amount,status,city,district,state,bank,uploaded_by,uploaded_on,complete_status) VALUES('$updated_date','$data[1]','$data[2]','$data[3]','$data[4]','$data[5]','$data[6]','$data[7]','$data[8]','$data[9]','$asset_user_name','$today','0')";
					$result = mysqli_query($link, $sql);

					if (!$result)
					{
						$errorMessage = 'Error in executing query';
					}
					else
					{
						$successMessage = 'Receipts uploaded successfully';
					}
					//break;
				}
			    fclose($handle);
	    	}
	    	
	    }
	}
	else
	if (isset($_POST['export'])) 
	{
		$sql = "SELECT * FROM nafa_unidentified_receipts1 WHERE complete_status='1'";
		$res = mysqli_query($link,$sql);
		if(mysqli_num_rows($res) > 0)
		{
				
		    $delimiter = ",";
		    $filename = "Identified_Receipts_" . date('Y-m-d') . ".csv";
		    
		    //create a file pointer
		    $f = fopen('php://memory', 'w');
		    
		    //set CSV column headers
		    $fields = array('unidentified_receipts_id', 'value_date', 'description', 'ref_no', 'branch_code', 'amount', 'status', 'city', 'district', 'state', 'bank', 'customer_code', 'customer_name', 'remark', 'identified_by', 'remarked_on', 'Update status');
		    fputcsv($f, $fields, $delimiter);
		    while($row = mysqli_fetch_array($res))
		    {
		    	$lineData = array(
					''.$row['unidentified_receipts_id'].'',
					''.$row['value_date'].'',
					''.$row['description'].'',
					''.$row['ref_no'].'',
					''.$row['branch_code'].'',
					''.$row['amount'].'',
					''.$row['status'].'',
					''.$row['city'].'',
					''.$row['district'].'',
					''.$row['state'].'',
					''.$row['bank'].'',
					''.$row['customer_code'].'',
					''.$row['customer_name'].'',
					''.$row['remark'].'',
					''.$row['identified_by'].'',
					''.$row['remarked_on'].''
				);
				fputcsv($f, $lineData, $delimiter);

				$unidentified_receipts_id = $row['unidentified_receipts_id'];
		    
		    	$sql1 = "UPDATE nafa_unidentified_receipts1 SET downloaded_by='$asset_user_name',downloaded_at='$today' WHERE unidentified_receipts_id='$unidentified_receipts_id'";
				if($link->query($sql1) === TRUE)
				{
					continue;
				}
				else
				{
					$errorMessage = "Error executing query! Try after some time.";
				}
		    }
		    //move back to beginning of file
		    fseek($f, 0);
		    
		    //set headers to download file rather than displayed
		    header('Content-Type: text/csv');
		    header('Content-Disposition: attachment; filename="' . $filename . '";');
		    
		    //output all remaining data on a file pointer
		    fpassthru($f);
		}
		else
		{
			$errorMessage = "No receipts found for requested parameter";
		}
		if($errorMessage=='' || $errorMessage==null)
		{
			exit;
		}
	}
	else
	if (isset($_POST['import_identified_receipts'])) 
	{
	    $i=0; //so we skip first row
	    $file_ext = null;

	    $filename = $_FILES['mapped_receipts']['name'];
	    if(empty($filename))
	    {
	    	$errorMessage = 'Please select file to upload identified receipts';        //error if file not selected
	    }	
	    else
	    {
	    	$file_ext=strtolower(end(explode('.',$_FILES['mapped_receipts']['name'])));
	    	
	    	if($file_ext!='csv')
	    	{
	    		$errorMessage = "Only csv files can be uploaded! ";
	    	}
	    	else
	    	{
	    		$handle = fopen($_FILES['mapped_receipts']['tmp_name'], "r");
				
				$i=0;
				while (($data = fgetcsv($handle, 10000, ",")) !== FALSE) 
				{	
					 
				 	$i++;
				    if($i==1) continue;
				    if($data[16] == 'Mapped'){
					$today = date('Y-m-d H:i:s');
					//$sql = "UPDATE nafa_unidentified_receipts1 SET "
				    $sql = "UPDATE nafa_unidentified_receipts1 SET mapped_by='$asset_user_name',mapped_on='$today',mapped_remark='$data[16]',complete_status='2' WHERE unidentified_receipts_id='$data[0]'";
					
					if($link->query($sql) === TRUE)
					{
						header('Location:unidentified_receipts_utility.php');
					}
					else
					{
						$errorMessage = 'Error Mapping receipt';
					}
					//break;
					 }else{
					 	$errorMessage = 'Sorry..! Please Make update status mapped';
					 }
				}
			    fclose($handle);
	    	}
	    }
	}
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>Unidentified receipt</title>
<?php include "includes/naf_links.inc.php";?>

</head>
<body>
	<div id="container"> 
		<div class="loading_image"></div>
	    <?php include "inc_main_menu.php";  ?>    	       
		<?php include "inc_message.php";?>
		<div id="container">
			<div>
			  	<h3 class="page_title">Unidentified Receipt Utility</h3>
				<table width="600">
				<form action="<?php echo $_SERVER["PHP_SELF"]; ?>" method="post" enctype="multipart/form-data">
					<tr>
			    		<td><strong>For sample csv file click on sample file</strong></td>
			    		<td>Sample file : <a href='unidentified_receipts/unidentified_receipts.csv' style='color:red;'>Click here</a></td>
		    		</tr>
					<tr>
					<td width="20%"><strong>Select file for upload</strong></td>
					<td width="80%"><input type="file" name="fileToUpload" id="fileToUpload"  /></td>
					</tr>

					<tr>
						<td><strong>Submit</strong>&nbsp;&nbsp;&nbsp;&nbsp; <input type="submit" name="submit" class='btn-submit submit_btn btn-info'/></td>
						<td> 
							<div class='loading' style='display:none;'>
								<p class='loading_classs' style='color:red;'>Please Wait!</p>
							</div>
							<?php

								if ($errorMessage != '')
								{
									echo "<strong style='color:red;'>Error! $errorMessage </strong>";
								}

								if ($successMessage != '')
								{
									echo "<div class='success_receipt_upload' style='padding: 10px; margin-bottom: 10px;'>";
									echo "<strong style='color:green;'>Success! $successMessage </strong>";
									echo "</div>";
								}

							?>
						</td>
					</tr>
					<tr>
						<td><strong>Export Identified receipts:</strong> &nbsp;&nbsp;&nbsp;<input type="submit" name="export" value="Export"/></td>
						<td><strong>Upload Mapped receipts:</strong> &nbsp;&nbsp;&nbsp;<input type="file" name="mapped_receipts" id="mapped_receipts"  />&nbsp;&nbsp;&nbsp;<input type="submit" name="import_identified_receipts" value="Map Receipts"/></td>
					</tr>
				</table>
				</form>
				
			</div>
			<div>
				<table>
					<tr style="background-color:#b3e5fc;">
						<th>Roll_Back</th>
						<th>receipts_id</th>
						<th>Receipt_Date</th>
						<th>Description</th>
						<th>Ref No.</th>
						<th>BranchCode</th>
						<th>Amount</th>
						<th>Status</th>
						<th>City</th>
						<th>District</th>
						<th>State</th>
						<th>Bank</th>
						<th>Cust Code</th>
						<th>Cust Name</th>
						<th>Remarks</th>
						<th>Attachment</th>
						<th>IdentifiedBy</th>
						<th>Final Status</th>
					</tr>
				<?php
					$sql = "SELECT * FROM nafa_unidentified_receipts1 WHERE complete_status IN('0','1') ORDER BY value_date DESC";
					$res = mysqli_query($link,$sql);
					if(mysqli_num_rows($res)>0)
					{
						while($row = mysqli_fetch_array($res))
						{
							$uploaded_document = $row['uploaded_document'];
							$unidentified_receipts_id = $row['unidentified_receipts_id'];
							echo "<tr>";
							$sql_check = "SELECT unidentified_receipts_id FROM nafa_unidentified_receipts1_history WHERE unidentified_receipts_id='$unidentified_receipts_id'";
							$res_check = mysqli_query($link,$sql_check);
							$count_check = mysqli_num_rows($res_check);
							if($count_check>0)
							{
								echo "<td><img src='img/alert.gif' style='width:20px;height:20px;' /></td>";
							}
							else
							{
								echo "<td></td>";
							}
							echo "<td>".$row['unidentified_receipts_id']."</td>";
							echo "<td>".date('d-m-Y', strtotime($row['value_date']))."</td>";
							echo "<td>".$row['description']."</td>";
							echo "<td>".$row['ref_no']."</td>";
							echo "<td>".$row['branch_code']."</td>";
							echo "<td>".$row['amount']."</td>";
							echo "<td>".$row['status']."</td>";
							echo "<td>".$row['city']."</td>";
							echo "<td>".$row['district']."</td>";
							echo "<td>".$row['state']."</td>";
							echo "<td>".$row['bank']."</td>";
							echo "<td>".$row['customer_code']."</td>";
							echo "<td>".$row['customer_name']."</td>";
							echo "<td>".$row['remark']."</td>";
							echo "<td>";
							if($uploaded_document!='' || $uploaded_document!=null)
							{
								$uploaded_document = explode(',',$uploaded_document);
							
								for($i=0;$i<count($uploaded_document);$i++)
								{
									$no = $i+1;
									echo "<strong><a target='_blank' href='$uploaded_document[$i]'> Doc-".$no." </a>";
									echo "<br/>";
								}
									
								
							}
							echo "</td>";
							echo "<td>".$row['identified_by']."</td>";
							if($row['complete_status'] == '0')
							{
								$complete_status = "<strong style='color:#ff1744;'>Un-identified</strong>";
							}
							else
							if($row['complete_status'] == '1')
							{
								$complete_status = "<strong style='color:#00c853;'>Identified</strong>";
							}
							echo "<td>".$complete_status."</td>";
							echo "</tr>";
						}
					}
					else
					{
						echo "<tr>";
							echo "<td colspan='15'> No record found.</td>";
						echo "</tr>";
					}
				?>
				</table>
			</div>
		</div>
	</div>
</body>
</html>
<script>
	$(document).ready(function(){
		$('.submit_btn').click(sunction(){
			$('.loading_classs').show();
		});
	});
</script>